#!/bin/sh

# Copyright (c) 2016-2017 Konica Minolta Laboratory USA, Inc
# San Mateo, CA, USA      All Rights Reserved.
#
# modification history (latest on top)
# --------------------
# 05jun17,spn   added error detection
# 25aug16,spn   created

# End of LCM is 0xd0ffffff
SUSPEND_ADDR="0xd0ffffe0"
RESUME_ADDR="0xd0fffff0"

STATUS=0

do_error () {
	echo $1
	STATUS=1
}

# Initialize the suspend areas to zero
suspendAreaInit () {
        devmem 0xd0ffffe0 32 0 || do_error "devmem failed"
        devmem 0xd0ffffe4 32 0 || do_error "devmem failed"
        devmem 0xd0ffffe8 32 0 || do_error "devmem failed"
        devmem 0xd0ffffec 32 0 || do_error "devmem failed"
}

# Initialize the resume areas to zero
resumeAreaInit () {
        devmem 0xd0fffff0 32 0 || do_error "devmem failed"
        devmem 0xd0fffff4 32 0 || do_error "devmem failed"
        devmem 0xd0fffff8 32 0 || do_error "devmem failed"
        devmem 0xd0fffffc 32 0 || do_error "devmem failed"
}

suspendAreaInit
resumeAreaInit

exit $STATUS
