#
# checkfs.sh	Check filesystems.
#

echo -e "\nPhase(checkfs)"

hdddev=/dev/sda

func_format () {
	echo "  Format $1 $2"
	mkfs.$2 $1
	tune2fs -c 1 -i 0 $1
}

func_isMountOK () {
	error=0
	mount -n -t $2 $1 /mnt 2> /dev/null
	ret_mount=$?
	if [ $ret_mount -ne 0 ]
		then
		error=1
	else
		if [ -d /mnt/lost+found ]
			then
			rm -rf /mnt/lost+found/*
		fi
		umount /mnt
	fi
	return $error
}

# CHECK <partition size>
/etc/init.d/HDDPartitionSize.sh 81448511 e 138625024 all l 106741268 l 9703752 l all
ret_fdisk=$?
if [ $ret_fdisk -eq 0 ]
	then
	echo -e " Partition size\t\t[ OK ]"
	func_isMountOK ${hdddev}1 ext3
	ret1=$?
	func_isMountOK ${hdddev}3 ext3
	ret3=$?
	func_isMountOK ${hdddev}5 ext3
	ret5=$?
	func_isMountOK ${hdddev}6 ext3
	ret6=$?
	func_isMountOK ${hdddev}7 ext3
	ret7=$?

	if [ $ret1 -ne 0 -a $ret3 -ne 0 -a $ret5 -eq 0 -a $ret6 -eq 0 -a $ret7 -eq 0 ]
		then
		echo -e " Partition mount\t[ OK ]"
		# to be fsck
	else
		echo -e " Partition mount\t[ NG ]"
		# FORMAT Partition
		if [ $ret1 -eq 0 ]
		then
			echo "  Initializing ${hdddev}1"
			dd if=/dev/zero of=${hdddev}1 bs=512 count=8
		fi
		if [ $ret3 -eq 0 ]
		then
			echo "  Initializing ${hdddev}3"
			dd if=/dev/zero of=${hdddev}3 bs=512 count=8
		fi
		if [ $ret5 -ne 0 ]
		then
			func_format ${hdddev}5 ext3
		fi
		if [ $ret6 -ne 0 ]
		then
			func_format ${hdddev}6 ext3
		fi
		if [ $ret7 -ne 0 ]
		then
			func_format ${hdddev}7 ext3
		fi
		exit
	fi
else
	echo -e " Partition size\t\t[ NG ]"
	# ERASE Partition
	dd if=/dev/zero of=${hdddev} count=1
	# CREATE Partition
	fdisk -u ${hdddev} < /etc/fdisk_part.ini
	# FORMAT Partition
	dd if=/dev/zero of=${hdddev}1 bs=512 count=8
	func_format ${hdddev}5 ext3
	func_format ${hdddev}6 ext3
	func_format ${hdddev}7 ext3
	dd if=/dev/zero of=${hdddev}3 bs=512 count=8
	exit
fi

func_fsck_first () {
	echo "Checking file systems...1 $1"
	fsck.$2 -a $1
	ret_fsck=$?

	if [ $ret_fsck -eq 0 ]  # fsck: No errors
		then
		echo -e " fsck $1\t\t[ OK ]"
	elif [ $ret_fsck -eq 1 ] # fsck: File system errors corrected
		then
		echo -e " fsck $1\t\t[ Repair ]"
	fi
	
	if [ $ret_fsck -gt 1 ]
		then
		echo "fsck ERROR $ret_fsck"
	fi
	return $ret
}

func_fsck_second () {
	echo "Checking file systems...2 $1"
	fsck.$2 -f -y $1
	ret_fsck=$?

	if [ $ret_fsck -eq 0 ]
		then
		echo -e " fsck $1\t\t[ OK ]"
		ret=0
	elif [ $ret_fsck -eq 1 ]
		then
		echo -e " fsck $1\t\t[ Repair ]"
		ret=0
	else
		echo -e " fsck $1\t\t[ Trouble($ret_fsck) ]"
		ret=$ret_fsck
	fi

	return $ret
}

test -f /etc/fstab && (
	while read fs_spec fs_file fs_vfstype fs_mntops fs_freq fs_passno
	  do
	  if [ `echo $fs_spec | grep -e "^#"` ]
	  then
		continue
	  fi
	  if [ $fs_passno -eq 1 ]
		  then
		  func_fsck_first $fs_spec $fs_vfstype $statics
		  ret=$?
		  if [ $ret -ne 0 ]
			  then
			  func_fsck_second $fs_spec $fs_vfstype $statics
			  ret=$?
			  if [ $ret -ne 0 ]
				  then
				  case "$fs_spec" in
					  /dev/sd*)
						  func_format $fs_spec $fs_vfstype
						  ;;
				  esac
			  fi
		  fi
	  fi
	done
) < /etc/fstab
