#!/bin/ash

/bin/stty isig

SD_DEV=/dev/kmsda
MMC_DEV=/dev/mmcblk0

############################################################
# function definitions
############################################################

read_partition_info ()
{

	PARTS_START=""
	PARTS_SIZE=""
	PART_COUNT=0
	MMC_END=0

	TMP_PARTNUM=1
	while :
	do
		if [ ${TMP_PARTNUM} -lt 10 ]; then
			TMP_SFDISK=`fdisk -lu ${SD_DEV} | grep "${SD_DEV}${TMP_PARTNUM} "`
		else
			TMP_SFDISK=`fdisk -lu ${SD_DEV} | grep "${SD_DEV}${TMP_PARTNUM}"`
		fi

		if [ -z "${TMP_SFDISK}" ]; then
			PART_COUNT=`expr ${TMP_PARTNUM} - 1`
			break
		fi

		TMP_START=`echo -e ${TMP_SFDISK} | sed -e 's/\s\{1,\}/ /g' | cut -d " " -f 2`
		TMP_SIZE=`echo -e ${TMP_SFDISK} | sed -e 's/\s\{1,\}/ /g' | cut -d " " -f 4 | sed -e "s/+//g"`
		TMP_SIZE=`expr ${TMP_SIZE} \* 2`

		if [ ${TMP_SIZE} -eq 0 ]; then
			PART_COUNT=`expr ${TMP_PARTNUM} - 1`
			break
		fi

		PARTS_START="${PARTS_START} ${TMP_START}"
		PARTS_SIZE="${PARTS_SIZE} ${TMP_SIZE}"

		if [ ${TMP_PARTNUM} -lt 4 ]; then
			if [ ${TMP_PARTNUM} -eq 1 ]; then
				SFDISK_STRING="${TMP_START},${TMP_SIZE},L"
			else
				SFDISK_STRING="${SFDISK_STRING}\n${TMP_START},${TMP_SIZE},L,*"
			fi
		elif [ ${TMP_PARTNUM} -gt 4 ]; then
			SFDISK_STRING="${SFDISK_STRING}\n${TMP_START},${TMP_SIZE},L"
		else # elif [ ${TMP_PARTNUM} -eq 4 ]; then
			SFDISK_STRING="${SFDISK_STRING}\n${TMP_START},${TMP_SIZE},E"
		fi

		MMC_END=`expr ${TMP_START} + ${TMP_SIZE}`
		TMP_PARTNUM=`expr ${TMP_PARTNUM} + 1`
	done

}

if [ `cat /sys/block/kmsda/device/type` = "MMC" ] ; then
	echo "Current boot device is eMMC!"
	exit
fi

echo
echo "############################################################"
echo "# eMMC MIGRATION TOOL                                      #"
echo "#                                                          #"
echo "# This utility must be run directly on the target unit     #"
echo "# It will initialize the eMMC NAND partition table using   #"
echo "# data from the plug-in SD card.                           #"
echo "############################################################"
echo

# read partition table
read_partition_info
if [ `expr ${MMC_END} / 2048` = 0 ] ; then
    MMC_END_MB=`expr ${MMC_END} / 2048`
else
    MMC_END_MB=`expr ${MMC_END} / 2048 + 1`
fi

echo "[ROM Information]"
echo "    Size      : $MMC_END_MB [MB]"
echo "    Partition : $PART_COUNT"
echo 

echo "Writing FW to eMMC"
echo "(WAIT!) ... this process can take 2-5 minutes"
echo 

sync; sync; sync

#backup eMMC part 23 data
mount -t tmpfs -o size=16m tmpfs /ram1
dd if=/dev/mmcblk0p23 of=/ram1/lxknvram bs=1M count=16

# disable write protect
echo 0 > /sys/block/mmcblk0/mmcblk0boot0/force_ro

# write to boot partition
dd if=${SD_DEV} of=/dev/mmcblk0boot0 bs=512 count=4096

echo "MMC_END_MB=${MMC_END_MB}"
dd if=${SD_DEV} of=${MMC_DEV} bs=1M count=${MMC_END_MB} &

while [ ! -z `pidof dd` ]
do
	pidof dd | xargs kill -USR1
	sleep 10
done

# restore eMMC part 23 data
dd if=/ram1/lxknvram of=/dev/mmcblk0p23 bs=1M count=16
umount /ram1

sync; sync; sync;

echo
echo "COMPLETE!!!"
