#!/bin/sh

# Copyright (c) 2016-2017 Konica Minolta Laboratory USA, Inc
# San Mateo, CA, USA      All Rights Reserved.
#
# modification history (latest on top)
# --------------------
# 05jun17,spn   added error detection
# xxxxxxx,kmi   based on HLUS test code
#

STATUS=0

do_error () {
	echo $1
	STATUS=1
}

if [ "$1" = "add" ] ; then
	CHECK_PARTITION=/dev/kmsdb12
	CHECK_NET_DEVICE=/sys/class/net/mem0

	ls $CHECK_PARTITION > /dev/null 2>&1

	if [ $? -eq 0 ]; then
		echo "$CHECK_PARTITION exist."
	else
		do_error "$CHECK_PARTITION not exist. stop nbd server control."
		exit $STATUS
	fi

	ls $CHECK_NET_DEVICE > /dev/null 2>&1

	if [ $? -eq 0 ]; then
		echo "$CHECK_NET_DEVICE exist."
	else
		do_error "$CHECK_NET_DEVICE not exist. stop nbd server control."
		exit $STATUS
	fi

#	ls /tmp/nbd-server.lx-nv.pid > /dev/null 2>&1
	ls /tmp/nbd-server.parent.lx-nv.pid > /dev/null 2>&1

	if [ $? -eq 0 ]; then
		do_error "nbd-server running. stop nbd server control."
		exit $STATUS
	fi

	echo "start nbd-server"

	# start NVRAM NBD Server
#	/usr/bin/nbd-server -p /tmp/nbd-server.lx-nv.pid -C /etc/nbd-server/lx-nv-config
	/usr/bin/nbd-server -p /tmp/nbd-server.lx-nv.pid -z /tmp/nbd-server.parent.lx-nv.pid -C /etc/nbd-server/lx-nv-config

	if [ $? -ne 0 ]; then
		do_error "failed to start nbd-server."
	fi

#	pid=$(cat /tmp/nbd-server.lx-nv.pid)
	pid=$(cat /tmp/nbd-server.parent.lx-nv.pid)

	if [ $? -ne 0 ]; then
#		do_error "cat failed on /tmp/nbd-server.lx-nv.pid."
		do_error "cat failed on /tmp/nbd-server.parent.lx-nv.pid."
	else
		# only use chrt if pid is set to protect pid 100
		chrt -r -p 100 $pid

		if [ $? -ne 0 ]; then
			do_error "chrt failed on $pid"
		fi
	fi

	# notify NV Proxy Server of NVRAM power up
	/tools/lxNvProxyClient 1; ret=$?

	if [ $ret -ne 0 ]; then
		do_error "lxNvProxyClient failed with code $ret."
	fi
elif [ "$1" = "remove" ] ; then

	echo "stop nbd-server"

	# notify NV Proxy Server of NVRAM power down
	/tools/lxNvProxyClient 0; ret=$?

	if [ $ret -ne 0 ]; then
		do_error "lxNvProxyClient failed with code $ret."
	fi

#	pid=$(cat /tmp/nbd-server.lx-nv.pid)
	pid=$(cat /tmp/nbd-server.parent.lx-nv.pid)

	if [ $? -ne 0 ]; then
#		do_error "cat failed on /tmp/nbd-server.lx-nv.pid."
		do_error "cat failed on /tmp/nbd-server.parent.lx-nv.pid."
	else
		# stop NVRAM NBD Server
		kill $pid

		if [ $? -ne 0 ]; then
			do_error "failed to kill $pid."
		else
#			rm /tmp/nbd-server.lx-nv.pid
			rm /tmp/nbd-server.parent.lx-nv.pid
#			if [ $? -ne 0 ]; then
#				do_error "rm failed on /tmp/nbd-server.lx-nv.pid."
#				do_error "rm failed on /tmp/nbd-server.parent.lx-nv.pid."
#			fi
		fi
	fi
else
	do_error "usage: lxNvCtrl [add|remove]"
fi

exit $STATUS
