#!/bin/sh

# Copyright (c) 2016-2017 Konica Minolta Laboratory USA, Inc
# San Mateo, CA, USA      All Rights Reserved.
#
# modification history (latest on top)
# --------------------
# 05jun17,spn   added error detection
# 03may17,thien added handling for memnet heartbeat
# 25aug16,spn   created

STATUS=0

# End of LCM is 0xd0ffffff
SUSPEND_ADDR="0xd0ffffe0"
RESUME_ADDR="0xd0fffff0"

do_error () {
        echo $1
        STATUS=1
}

echo -n "Send resume request to engine side..."
devmem $RESUME_ADDR 8 1 || do_error "devmem failed"
echo "done."

echo -n "Wait for engine to acknowledge resume..."
i=0;
last=2;
while [ true ]; do
	val=$(devmem $RESUME_ADDR 8)

	if [ $? -ne 0 ]; then
		do_error "devmem failed"
		break
	elif [ "$val" == "0x00" ]; then
		break
	fi

	i=$(expr $i + 1)

	if [ $i -lt $last ]; then
		sleep 1
		echo -n "."
	else
		do_error "timeout detected!"
		break
	fi
done
echo "done."

echo -n "Send resume request to memnet heartbeat..."
pid=$(pidof heartbeat)

if [ $? -ne 0 ]; then
	do_error "failed."
else
	kill -s SIGUSR1 $pid

	if [ $? -ne 0 ]; then
		do_error "failed."
	else
		echo "done."
	fi
fi

echo

exit $STATUS
