#!/bin/bash

exec 9>> /var/xauth.lock
flock 9
echo "xauthadd.sh $$ start $1"

MFPHOST=$1
if [ "${MFPHOST}" = "" ] ; then
    MFPHOST=`hostname`
    while [ ${MFPHOST} = '(none)' ]
    do
        sleep 1
        MFPHOST=`hostname`
    done
fi

XORGDIR=/xorg
XAUTH_LIST=`${XORGDIR}/bin/xauth -f ~/.Xauthority list`
SEARCH_STR1="^${MFPHOST}/unix:0\s"
SEARCH_STR2="\s${MFPHOST}/unix:0\s"
if echo ${XAUTH_LIST} | grep -q -e ${SEARCH_STR1} -e ${SEARCH_STR2} ; then
    echo "already xauth list $$ ${MFPHOST} $1"
    flock -u 9
    exit
fi

HEXKEY=`/xorg/bin/mcookie`
XPID=`pgrep -f [s]tartx`

${XORGDIR}/bin/xauth add ${MFPHOST}/unix:0 . $HEXKEY
${XORGDIR}/bin/xauth -q -f ~/.serverauth.${XPID} add ${MFPHOST}/unix:0 . $HEXKEY
echo "xauth add ${MFPHOST}/unix:0 $$"
flock -u 9
