#!/bin/bash

# Check Partition Size (/dev/sda) & Create /etc/fdisk_part.ini
# usage: ./HDDPartitionSize.sh [e|l] <num of sector> <num of sector> all
#        argument data
#          <num of sector>: natural number (-> * 512bytes = partition size)
#          option [e]     : mark of extended partition [use only once]
#          option [l]     : mark of logical partition
#
# exit value:
#             0(partition size is good)
#             2(Need fdisk)
#             1(error illegal / unbelievable)
all_sector=0

DEVICE="/dev/sda"

ret=`fdisk -ul $DEVICE`
if [ $? -ne 0 ]
then
	echo "not found: $DEVICE"
	exit 1
fi

# Get Sector size
#   Disk /dev/sda: 250.0 GB, 250059350016 bytes
#   255 heads, 63 sectors/track, 30401 cylinders, total 488397168 sectors
#                                                       $8
#   Units = sectors of 1 * 512 = 512 bytes
#
all_sector=`fdisk -ul $DEVICE | grep "heads," | cut -d" " -f8`

# <ERROR>
if [ `expr ${all_sector:-0}` -eq 0 ]
then
	echo "unbelievable error. cannot get value."
	exit 1
fi

# check $@ & decide partition size
#   partition size(num of sector)     -> param[]
#   partition type("n" or "e" or "l") -> part_type[]
#
cnt_extended=0              # counter of extended partitions
cnt_partition=0             # counter of partitions <MAX:15(maximum=primary:3 + extended:1 + logical:11)>
cnt_logical=0               # counter of logical partitions <MAX:11>
check_subtotal=0            # check size of total sector
check_extened_all=0         # size of extended partition sector
check_extened_subtotal=0    # check size of extended partition sector

for argv in $@
do
	case "$argv" in
		e)
			cnt_extened=`expr $cnt_extended + 1`
			part_type[$cnt_partition]="e"
			;;

		l)
			if [ $cnt_extended -ne 0 ]
			then
				echo "invalide parameter."
				exit 1
			fi
			part_type[$cnt_partition]="l"
			cnt_logical=`expr $cnt_logical + 1`
			;;

		[0123456789]*)
			param[$cnt_partition]=$argv

			if [ -z ${part_type[cnt_partition]} ]
			then
				part_type[$cnt_partition]="p"
				check_subtotal=`expr $check_subtotal + $argv`
			elif [ "${part_type[cnt_partition]}" = "e" ]
			then
				check_extened_all=$argv
				check_subtotal=`expr $check_subtotal + $argv`
			else
				check_extened_subtotal=`expr $check_extened_subtotal + $argv`
				if [ $check_extened_subtotal -gt $check_extened_all ]
				then
					echo "not enough partition. 1"
					exit 1
				fi
			fi

			cnt_partition=`expr $cnt_partition + 1`
			;;

		all)
			if [ "${part_type[cnt_partition]}" = "l" ]
			then
				param[$cnt_partition]=`expr $check_extened_all - $check_extened_subtotal`
				if [ ${param[cnt_partition]} -le 0 ]
				then
					echo "not enough partition. 3"
					exit 1
				fi
			else
				if [ -z ${part_type[cnt_partition]} ]
				then
					part_type[$cnt_partition]="p"
				fi

				check_subtotal=`expr $check_subtotal`
				param[$cnt_partition]=`expr $all_sector - $check_subtotal`
				if [ ${param[cnt_partition]} -le 0 ]
				then
					echo "not enough partition. 2"
					exit 1
				fi
			fi

			cnt_partition=`expr $cnt_partition + 1`
			;;

		*)
			echo "invalid!!  argv:$argv"
			exit 1
			;;
	esac

	# <ERROR #1>
	if [ $cnt_partition -gt 15 -o $cnt_logical -gt 11 -o $cnt_extended -gt 1 ]
	then
		echo "invalide parameter."
		exit 1
	fi
done

# <ERROR #2>
if [ $cnt_partition -eq 0 -o $check_subtotal -gt $all_sector -o `expr $cnt_partition - $cnt_logical` -gt 4 ]
then
	echo "invalide parameter."
	exit 1
fi


# create partition file
#   partition size(end of sector) -> part_size[]  (for Check Partition Size)
#
rm -f /etc/fdisk_part.ini
cnt=0
cnt_pri_ext=0        # counter of primary and extended partitions
cnt_logical=5        # counter of logical partitions[/dev/sda5 ...]
value_partition=0    # partition size(end of sector) of primary or extended partition
value_logical=0      # partition size(end of sector) of logical partition
set_value=0          # setting value

while [ $cnt -ne $cnt_partition ]
do
	# Command
	echo "n" >> /etc/fdisk_part.ini

	if [ "${part_type[cnt]}" = "p" -o "${part_type[cnt]}" = "e" ]
	then
		# Base Extended Partition
		if [ "${part_type[cnt]}" = "e" ]
		then
			value_logical=`expr $value_partition`
		fi

		value_partition=`expr $value_partition + ${param[cnt]}`

		# fill in gaps  for 1st Partition
		if [ $cnt -eq 0 ]
		then
			value_partition=`expr $value_partition - 1`
		fi

		cnt_pri_ext=`expr $cnt_pri_ext + 1`

		# Command('n') action
		echo "${part_type[cnt]}" >> /etc/fdisk_part.ini
		if [ $cnt_pri_ext -lt 4 ]
		then
			# Partition number
			echo `expr $cnt_pri_ext` >> /etc/fdisk_part.ini
		fi

		set_value=$value_partition

		part_size[$cnt_pri_ext]=$value_partition
	else
		# fill in gaps  for logical Partition
		value_logical=`expr $value_logical + ${param[cnt]}`

		if [ $cnt_pri_ext -lt 4 ]
		then
			# Command('n') action
			echo "${part_type[cnt]}" >> /etc/fdisk_part.ini
		fi

		set_value=$value_logical

		part_size[$cnt_logical]=$value_logical
		cnt_logical=`expr $cnt_logical + 1`
	fi

	# First sector
	echo "" >> /etc/fdisk_part.ini

	# Last sector
	echo "$set_value" >> /etc/fdisk_part.ini

	cnt=`expr $cnt + 1`
done
echo "w" >> /etc/fdisk_part.ini


ret=0  # exit value: OK=0, NG=2(Need fdisk), 1(error illegal / unbelievable)

# Check Partition Size (from sector)
#      Device Boot      Start         End      Blocks   Id  System
#   /dev/sda1              63    81448510    40724224   83  Linux
#   /dev/sda2        81448511   220073723    69312606+   5  Extended
#   /dev/sda3       220073724   488397167   134161722   83  Linux
#   /dev/sda5        81448574   188189841    53370634   83  Linux
#   /dev/sda6       188189905   197893656     4851876   83  Linux
#   /dev/sda7       197893720   220073723    11090002   83  Linux
#   $1                          $3
#
#   partition size(end of sector) -> part_size[]  (/dev/sda1 = part_size[1], ...)

cnt=0
no_partition=0    # number of partition

for data in `fdisk -ul $DEVICE | grep "^/dev" | sed 's/  */ /g' | cut -d" " -f1,3`
do
	case "$data" in
		/dev*)
			no_partition=${data#$DEVICE}
			;;
		*)
			if [ $data -ne ${part_size[no_partition]} ]
			then
				ret=2
				break;
			fi

			cnt=`expr $cnt + 1`
			;;
	esac
done

if [ $cnt -eq 0 -o $cnt -ne $cnt_partition ]
then
    exit 2
fi
exit $ret
