#
# setup_etc.sh  setup /etc
#
#  dd-July-2009  KONICA MINOLTA
#
echo -e "\nPhase(setup etc)"

cmd=`cat /proc/cmdline`
#echo "Kernel command line: $cmd"

for args in `echo $cmd`
do
	case $args in
		*root=/dev*)
			args=${args##*/}
			ROOT_DEVICE=${args%%[0-9]*}
			if [ -z $ROOT_DEVICE ]
			then
				ROOT_DEVICE=none
			fi
                        if [ $ROOT_DEVICE = "mmcblk" ]
                        then
                                ROOT_DEVICE="mmcblk1p"
                        fi

			break;
			;;
		*)
			ROOT_DEVICE=none
			;;
	esac
done

# fs_spec for /km (from /etc/fstab)
for args in `grep km /etc/fstab`
do
	case $args in
		/dev*)
			args=${args##*/}
			MFP_DEVICE=${args%%[0-9]*}
			if [ -z $MFP_DEVICE ]
			then
				MFP_DEVICE=none
			fi

			break;
			;;
		*)
			MFP_DEVICE=none
			;;
	esac
done

work_dir=/mnt

# check for fsck
if [ $ROOT_DEVICE != "none" ]
then
	# RAM disk
	if [ $ROOT_DEVICE = "mbfa" ]
	then
		ram_size=4
	else
		ram_size=6
	fi

	mount -n -t tmpfs -o noatime,size=${ram_size}m tmpfs ${work_dir}

	# restore /etc
	( cd /etc; tar cf - . ) | ( cd ${work_dir}; tar xf - ) 2> /dev/null
	#cp -af /etc/* ${work_dir}

	# renew /etc/fstab
#	if [ $MFP_DEVICE != "none" -a $ROOT_DEVICE != $MFP_DEVICE ]
#	then
		echo -n "use device ${ROOT_DEVICE}1 for /km"
		echo -en "\t[ Renew ]"
		sed "s/$MFP_DEVICE/$ROOT_DEVICE/g" ${work_dir}/fstab > ${work_dir}/fstab_tmp
		mv ${work_dir}/fstab_tmp ${work_dir}/fstab
		msg=`cat /proc/cmdline`
		set -- $msg
		case $1 in
		"boottyp=1")
			mv ${work_dir}/fstab_usb ${work_dir}/fstab
			;;
		"boottyp=2")
			mv ${work_dir}/fstab_sub ${work_dir}/fstab
			;;
		"boottyp=3" | "boottyp=5")
			mv ${work_dir}/fstab_iisw ${work_dir}/fstab
			;;
		"boottyp=9")
			mv ${work_dir}/fstab_upd ${work_dir}/fstab
			;;
		"boottyp=11" | "boottyp=12")
			mv ${work_dir}/fstab_backuprestore ${work_dir}/fstab
			;;
		esac

		echo $1
#	else
#	if [ "$1" = "boottyp=3" ]; then
#		mv ${work_dir}/fstab_iisw ${work_dir}/fstab
#	fi
#	fi
	echo

	mount -n --bind ${work_dir} /etc

	umount ${work_dir}

else
	echo "invalidate device.  (Kernel command line: $cmd)"
fi

