#!/bin/sh

tidof()
{
	# parameter check
	if [ $# -lt 1 ]; then
		return "0"
	fi

	tid=`ps H -eo comm,tid | grep "$1 " | sed -e "s/ \+/ /g" | cut -d ' ' -f 2`
	if [ -z "$tid" ]; then
		tid="0"
	fi
	echo "$tid"
	return "$tid"
}

CPU="1"

if [ -z "$1" ]; then
	CPU="1"
else
	CPU=$1
fi

# Emperor֘ACore01Ɋ.
echo `tidof tIJCMRPT` > /cgroup/grp$CPU/tasks
echo `tidof tIJCM`    > /cgroup/grp$CPU/tasks
echo `tidof tENGm`    > /cgroup/grp$CPU/tasks
echo `tidof tPM`      > /cgroup/grp$CPU/tasks
echo `tidof tTRAP`    > /cgroup/grp$CPU/tasks
echo `tidof tPJLUSm`  > /cgroup/grp$CPU/tasks
echo `tidof tRAS`     > /cgroup/grp$CPU/tasks
echo `tidof tLS`      > /cgroup/grp$CPU/tasks
echo `tidof tJDF`     > /cgroup/grp$CPU/tasks
echo `tidof tPJLUS`   > /cgroup/grp$CPU/tasks
echo `tidof tSPRNm`   > /cgroup/grp$CPU/tasks
echo `tidof tRS0`     > /cgroup/grp0/tasks
echo `tidof tRS1`     > /cgroup/grp$CPU/tasks

echo "[CPUSET] Core0 Group"
echo "---------------"
GRPLIST=`cat /cgroup/grp0/tasks`
for i in $GRPLIST; do
	if [ -d /proc/$i ]; then
		echo $i `cat /proc/$i/comm`
	fi
done
echo "---------------"
echo ""
echo "[CPUSET] Core1 Group"
echo "---------------"
GRPLIST=`cat /cgroup/grp1/tasks`
for i in $GRPLIST; do
	if [ -d /proc/$i ]; then
		echo $i `cat /proc/$i/comm`
	fi
done
echo "---------------"

