#!/bin/sh

# setgroup for taskname
taskgroup()
{
	# parameter check
	if [ $# -lt 2 ]; then
		echo "error: invalid parameter."
		return 1
	fi
	# directory check
	if [ ! -d "$CGPATH/$1" ]; then
		echo "error: no directory."
		return 1
	fi

	# task grouping
	local tskps=$(ps H -eo comm,tid | sed -e "s/ \+/ /g")
	local tskskip=1
	for i in $(echo $@ | sed "s/\"//g")
	do
		if [ $tskskip -ne 0 ]; then
			tskskip=$(expr $tskskip - 1)
		else
			local tidlist=$(echo "$tskps" | grep -e "^$i " | sed -e "s/$i//g")
			if [ -n "$tidlist" ]; then
				for tid in $tidlist
				do
					echo "setgroup $1 $tid - $i"
					echo $tid >> $CGPATH/$1/tasks
				done
			else
				echo "NotFound!! Task=$i"
			fi
		fi
	done
	return 0
}

# tasklist for cgroup
viewgroup()
{
	# directory check
	local grpname="default"
	local grppath=$CGPATH
	if [ $# -ne 0 ]; then
		grpname="group $1"
		grppath="$CGPATH/$1"
	fi
	if [ ! -d "$grppath" ]; then
		echo "error: no directory."
		return 1
	fi

	# tasklist
	local tskps=$(ps H -eo comm,tid | sed -e "s/ \+/ /g")
	local cpus=$(cat ${grppath}/cpuset.cpus)
	local mems=$(cat ${grppath}/cpuset.mems)
	echo "${grpname} - cpu=$cpus mem=$mems"
	echo "${grppath}/tasks"
	echo "------------------------------"
	local tidlist=$(cat ${grppath}/tasks)
	for i in $tidlist
	do
		local taskname=$(echo "$tskps" | grep " $i$" | cut -d" " -f1)
		echo "$i $taskname"
	done
	echo "------------------------------"
	echo ""
	return 0
}

# eof
